package gov.va.med.domain.service.messaging.decode.hl7.structure;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.RXA;
import ca.uhn.log.HapiLogFactory;

public class VXR_V03_RXANTE extends AbstractGroup
{
    public VXR_V03_RXANTE(Group parent) {
 	   super(parent);
 	   try {
 	      this.add(RXA.class, true, false);
 	      this.add(NTE.class, false, true);
 	   } catch(HL7Exception e) {
 	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating VXR_V03_ORCRXARXROBXNTE - this is probably a bug in the source code generator.", e);
 	   }
 	}
    
    public RXA getRXA()
    {
        RXA ret = null;
     	try {
     	    ret = (RXA)this.get("RXA");
     	} catch(HL7Exception e) {
     	    HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
     	}
     	return ret;
    }
    
    public NTE getNTE()
    {
        NTE ret = null;
     	try {
     	    ret = (NTE)this.get("NTE");
     	} catch(HL7Exception e) {
     	    HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
     	}
     	return ret;
    }
}
